//
//  Chap3.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/04/01.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap3_h
#define Chap3_h
/*----------------------------------------------------*/
/*［３］統計表配列の作成と印刷　　　　　　　　　　　　　　　　　  */
/*----------------------------------------------------*/
//T1,T2,T3型統計表配列の作成
double** MakeTabT1td(double (*f)(int,int,double),int k,int m,double al){
    /*Hayter td型関数f(int t,int t,double al)のT1型表配列{f(k,m,alMl(al,M,l)}_{M,l}の作成*/
    double **tab;/*tab[M][l]=*/
    int M,l;
    /*配列tabの動的確保*/
    tab=malloc((k+1)*sizeof(double*));
    for(M=0;M<=k;M++){
        tab[M]=malloc((k+1)*sizeof(double));
    };
    /*表配列tabの初期化*/
    for(M=0;M<=k;M++)for(l=0;l<=k;l++){tab[M][l]=NAN;};
    /*表配列tabの作成*/
    if(k<2||k>20||(m<2&&m!=-1)||al<1.0e-8||al>0.5)return tab;/*引数エラー*/
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l!=M-1){tab[M][l]=f(l,m,alMl(al,M,l));};
        };
    };
    return tab;
};
double** MakeTabT1t(double (*f)(int,int,double),int k,int m,double al){
    /*Dunnett t型関数f(int t,int t,double al)のT1型表配列{f(l-1,m,alMl(al,M,l)}_{M,l}の作成*/
    double **tab;/*tab[M][l]=*/
    int M,l;
    /*配列tabの動的確保*/
    tab=malloc((k+1)*sizeof(double*));
    for(M=0;M<=k;M++){
        tab[M]=malloc((k+1)*sizeof(double));
    };
    /*表配列tabの初期化*/
    for(M=0;M<=k;M++)for(l=0;l<=k;l++){tab[M][l]=NAN;};
    /*表配列tabの作成*/
    if(k<2||k>20||al<1.0e-8||al>0.5)return tab;/*引数エラー*/
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l!=M-1){tab[M][l]=f(l-1,m,alMl(al,M,l));};
        };
    };
    return tab;
};
double* MakeTabT3td(double (*f)(int,int,double),int k,int m,double al){
    /*Hayter td型関数f(int k,int k,double al)型関数のT3型表配列{f(l,m,al}_lの作成*/
    double *tab;/*tab[M][l]=*/
    int l;
    /*配列tabの動的確保*/
    tab=malloc((k+1)*sizeof(double));
    /*表配列tabの初期化*/
    for(l=0;l<=k;l++){tab[l]=NAN;};
    /*表配列tabの作成*/
    if(k<2||k>20||(m<2&&m!=-1)||al<1.0e-8||al>0.5)return tab;/*引数エラー*/
    for(l=2;l<=k;l++){tab[l]=f(l,m,al);};
    return tab;
};
double* MakeTabT2Dunnett(double (*f)(int,double*,double),int k,double* lms,double al){
    /*Dunnett t型関数f(int k,double* lms,double al)型関数のT2型表配列{f(l+1,m,al}_lの作成*/
    double *tab;/*tab[M][l]=*/
    int l;
    /*配列tabの動的確保*/
    tab=malloc((k+1)*sizeof(double));
    /*表配列tabの初期化*/
    for(l=0;l<=k;l++){tab[l]=NAN;};
    /*表配列tabの作成*/
    if(k<2||k>20||al<1.0e-8||al>0.5)return tab;/*引数エラー*/
    tab[0]=NAN;tab[k]=NAN;
    for(l=1;l<k;l++){tab[l]=f(l+1,lms,al);};
    return tab;
};
double* MakeTabT2DunnettT(double (*f)(int,double*,int,double),int k,double* lms,int m,double al){
    /*Dunnett T型関数f(int k,int* ns,double al)型関数のT2型表配列{f(l+1,m,al}_lの作成*/
    double *tab;/*tab[M][l]=*/
    int l;
    /*配列tabの動的確保*/
    tab=malloc((k+1)*sizeof(double));
    /*表配列tabの初期化*/
    for(l=0;l<=k;l++){tab[l]=NAN;};
    /*表配列tabの作成*/
    if(k<2||k>20||al<1.0e-8||al>0.5)return tab;/*引数エラー*/
    tab[0]=NAN;tab[k]=NAN;
    for(l=1;l<k;l++){
        tab[l]=f(l+1,lms,m,al);
    };
    return tab;
};

//T1,T2,T3型統計表配列の印刷
int PrintTabT1(int k,double** tab){
    /* T1型2次元表配列tab[k][k]の印刷*/
    int M,l;
    printf("  M\\l");
    for(l=2;l<=k;l++){printf("   %2d  ",l);};
    printf("\n");
    for(M=k;M>=2;M--){
        printf("  %2d  ",M);
        for(l=2;l<=M;l++){
            if(l==M-1){
                printf("   <>  ");
            }else{
                printf("%7.3f",tab[M][l]);
                
            }
        };
        printf("\n");
    };
    printf("\n");
    return 0;
};
int PrintTabT2(int k,double* tab){
    /* T2型1次元表配列tab[k]={nan,p_1,p_2,...,p_{k-1},nan}の印刷*/
    int l;
    printf("     k\\l ");
    for(l=k-1;l>0;l--){printf("  %2d  ",l);};
    printf("\n");
    printf("     %2d   ",k);
    for(l=k-1;l>0;l--){
        printf("%5.3f ",tab[l]);
    };
    printf("\n");
    return 0;
};
int PrintTabT3(int k,double* tab){
    /* T3型1次元表配列tab[k]={nan,nan,p_1,p_2,...,p_{k-1}}の印刷*/
    int l;
    printf("     k\\l ");
    for(l=k;l>=2;l--){printf("  %2d  ",l);};
    printf("\n");
    printf("     %2d   ",k);
    for(l=k;l>=2;l--){
        printf("%5.3f ",tab[l]);
    };
    printf("\n");
    return 0;
};

#endif /* Chap3_h */
